<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Log
 *
 * @mixin \Eloquent
 * @property int $id
 * @property int $ActionID
 * @property string $SenderName
 * @property string $RecipentName
 * @property string|null $ActionReason
 * @property string|null $remember_token
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereActionID($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereActionReason($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereRecipentName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereRememberToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereSenderName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Log whereUpdatedAt($value)
 */
class Log extends Model
{
    static function AddLog($actionid, $sender, $recipient, $reason)
    {
        $log = new Log();
        $log->ActionID = $actionid;
        $log->SenderName = $sender;
        $log->RecipentName = $recipient;
        $log->ActionReason = $reason;
        
        return $log->save();
    }
    
    static function getPageCount()
    {
        $pages = Log::count()/30;
        
        return $pages;
    }
    
    static function EventName($eventid)
    {
        switch($eventid) {
            case 0: {
                return 'Назначение';
            }
            case 1: {
                return 'Снятие';
            }
            case 2: {
                return 'Повышение';
            }
            case 3: {
                return 'Понижение';
            }
            case 4: {
                return 'Успешная авторизация (в панели)';
            }
            case 5: {
                return 'Успешная авторизация (в игре)';
            }
            case 6: {
                return 'Неудачная авторизация (в игре, пароль неверен)';
            }
            case 7: {
                return 'Неудачная авторизация (в игре, ип сменился)';
            }
            case 8: {
                return 'Неудачная авторизация (на сайте, ип сменился)';
            }
            case 9: {
                return 'Неудачная авторизация (на сайте, пароль неверен)';
            }
            case 10: {
                return 'Сменил пароль';
            }
            case 11: {
                return 'Деавторизация (аккаунт не найден)';
            }
            case 12: {
                return 'Деавторизация (сменился ип адрес)';
            }
            case 13: {
                return 'Регистрация';
            }
            case 14: {
                return 'Неудачная авторизация (на сайте, не зарегестрирован)';
            }
            case 15: {
                return 'Попытка регистрации админки на гостевом сервере';
            }
        }
        return $pages;
    }

    protected function getItems() {
        return Log::orderBy('created_at', 'desc')->paginate(20);
    }
}
