<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class UpRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $user = \App\User::getUser($value);
        if ($user->level < 6) return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Ошибка: Вы пытаетесь дать ранг выше 6 или пытаетесь повысить спец.админа';
    }
}
