@extends('layouts.app')
@section('content')
    <div id="wrapper">
        @include('includes.navbar')
        @include('includes.sidebar')
    </div>
    <div class="content-page">
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="page-title-box">
                            <h4 class="page-title">Просмотр логов</h4>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="card-box">
                            <table class="table table-striped m-0">
                                <thead>
                                <tr>
                                    <th class="text-center">ID</th>
                                    <th class="text-center">Действие</th>
                                    <th class="text-center">Админ</th>
                                    <th class="text-center">Получатель</th>
                                    <th class="text-center">Причина</th>
                                    <th class="text-center">Время</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if(count($logs) > 0)
                                    @foreach ($logs as $log)
                                        <tr>
                                            <td class="text-center">{{ $log->id }}</td>
                                            <td class="text-center">{{ \App\Log::EventName($log->ActionID) }}</td>
                                            <td class="text-center">{{ $log->SenderName }}</td>
                                            <td class="text-center">{{ $log->RecipentName }}</td>
                                            <td class="text-center">{{ $log->ActionReason }}</td>
                                            <td class="text-center">{{ $log->created_at }}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="6">
                                            <div class="text-center alert alert-info alert-dismissible fade in" role="alert">
                                                По запросу нет данных.
                                            </div>
                                        </td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>

                            <div class="text-center">
                                {{ $logs->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('my_scripts')
    {!! script_ts('/assets/js/project/common.js') !!}
@endsection