<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class DownRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $user = \App\User::getUser($value);
        if ($user->level > 1) return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Ранг должен быть в промежутку от 1 до 6.';
    }
}
