@extends('layouts.app')
@section('content')
    <div id="wrapper">
        @include('includes.navbar')
        @include('includes.sidebar')
    </div>
    <div class="content-page">
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="page-title-box">
                            <h4 class="page-title">Управление пользователями</h4>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="card-box">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            @include('includes.alerts')

                            @include('includes.users')
                        </div>
                    </div>

                    @if (\App\User::IsManagePermissions() == 'success')
                        @include('includes.add_form')
                    @endif
                    
                    @include('includes.change_pass_form')
                </div>
            </div>
        </div>
    </div>
@endsection

@section('my_scripts')
    {!! script_ts('/assets/js/project/common.js') !!}
@endsection