<?php $__env->startSection('content'); ?>
    <div id="wrapper">
        <?php echo $__env->make('includes.navbar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php echo $__env->make('includes.sidebar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </div>
    <div class="content-page">
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12">
                        <div class="page-title-box">
                            <h4 class="page-title">Просмотр логов</h4>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <div class="col-xs-12">
                        <div class="card-box">
                            <table class="table table-striped m-0">
                                <thead>
                                <tr>
                                    <th class="text-center">ID</th>
                                    <th class="text-center">Действие</th>
                                    <th class="text-center">Админ</th>
                                    <th class="text-center">Получатель</th>
                                    <th class="text-center">Причина</th>
                                    <th class="text-center">Время</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(count($logs) > 0): ?>
                                    <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center"><?php echo e($log->id); ?></td>
                                            <td class="text-center"><?php echo e(\App\Log::EventName($log->ActionID)); ?></td>
                                            <td class="text-center"><?php echo e($log->SenderName); ?></td>
                                            <td class="text-center"><?php echo e($log->RecipentName); ?></td>
                                            <td class="text-center"><?php echo e($log->ActionReason); ?></td>
                                            <td class="text-center"><?php echo e($log->created_at); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6">
                                            <div class="text-center alert alert-info alert-dismissible fade in" role="alert">
                                                По запросу нет данных.
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>

                            <div class="text-center">
                                <?php echo e($logs->links()); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('my_scripts'); ?>
    <?php echo script_ts('/assets/js/project/common.js'); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>