<?php

namespace App\Http\Controllers;

use App\Rules\ServerRule;
use App\Rules\DeleteRule;
use App\Rules\UpRule;
use App\Rules\DownRule;
use App\Rules\CheckMd5Password;
use App\Rules\CheckSessionUser;
use Illuminate\Http\Request;
use App\User;
use App\Log;
use \Session;
use \Validator;

class AdminAuthController extends Controller
{
    public function logout() {
        Session::flush();
        return redirect()->route('login');
    }
    
    public function home() {
        return view('home')->with([
            'users'=> User::getAll()
        ]);
    }
    
    public function validateuser(Request $request) {
        if($request->input('skey') != env('SKEY')) return 'IK|0';

        $signinName = $request->input('nick');
        $signinPassword = $request->input('password');
        $signinServer = $request->input('server');
        $signinIP = $request->input('ip');

        $user = User::getUser($signinName);
        if(empty($user)) return 'NO|0';
        
        $exitlevel = $user->level;
        $newadmin = 0;
        
        if($user->password == '-' && $signinServer != $user->server) {
            Log::AddLog(15, $signinName, $signinServer, $signinIP);
            return 'NO|0';
        }
        
        if($user->password != '-') {
            if(md5($signinPassword) != $user->password) 
            {
                Log::AddLog(6, $signinName, $signinServer, $signinIP);
                return 'PI|0';
            }
            
            
            if($signinServer != $user->server)
            {
                if($signinIP != $user->ip) 
                {
                    Log::AddLog(7, $signinName, $signinServer, $signinIP);
                    return 'IC|0';
                }
                
                if($user->level == 3 || $user->level == 4) $exitlevel = 2;
                if($user->level == 5) $exitlevel = 3;
                if($user->level == 6) $exitlevel = 4;
            }
        }
        else {
            $user->password = md5($signinPassword);
            $newadmin = 1;
        }
        
        $user->lastip = $signinIP;
        $user->lastserver = $signinServer;
        $user->lastlogin = time();
        
        $user->save();
        
        if($newadmin) {
            Log::AddLog(13, $signinName, $signinServer, $signinIP);
            return 'FL|0';
        }
        
        Log::AddLog(5, $signinName, $signinServer, $signinIP);
        
        return $exitlevel;
    }

    public function addUser(Request $request) {
        $validator = \Validator::make($request->all(),[
            'nick' => 'required|string|min:3|max:24|unique:users,name',
            'level' => 'required|integer|min:1|max:6',
            'server' => ['required', 'integer', new ServerRule]
        ], [
            'nick.required' => 'Вы не указали никнейм',
            'nick.min' => 'Никнейм не должен быть меньше 3 символов',
            'nick.max' => 'Никнейм не должен превышать 24 символа',
            'nick.unique' => 'Админ с этим Никнеймом уже существует',
            'level.required' => 'Вы не указали Ранг',
            'level.integer' => 'Ранг должен быть целочисленным значением',
            'level.min' => 'Ранг не должен быть меньше 1',
            'level.max' => 'Ранг не должен превышать 6',
            'server.required' => 'Вы не указали Сервер',
            'server.integer' => 'Сервер должен быть целочисленным значением',
        ]);
        if ($validator->fails()) {
            return redirect()->route('admin.main')->withInput()->withErrors($validator);
        }

        User::AddNewAdmin(
            $request->input('nick'),
            $request->input('level'),
            $request->input('server')
        );

        return view('home')->with([
            'users'=> User::getAll(),
            's_message' => 'Пользователь добавлен',
        ]);
    }

    public function changePassword(Request $request) {
        $validator = Validator::make($request->all(), [
            'old_password' => ['required', 'string', new CheckMd5Password],
            'new_password' => 'required|min:6|max:15',
            'new_password2' => 'required|min:6|max:15|same:new_password',
        ], [
            'old_password.required' => 'Вы не указали текущий пароль',
            'new_password.required' => 'Вы не указали новый пароль',
            'new_password.min' => 'Новый пароль не должен быть меньше 6 символов',
            'new_password.max' => 'Новый пароль не должен превышать 15 символов',
            'new_password2.required' => 'Вы не передали подтверждение нового пароля',
            'new_password2.min' => 'Данные в поле подтверждения пароля не должены быть меньше 6 символов',
            'new_password2.max' => 'Данные в поле подтверждения пароля не должены превышать 15 символов',
            'new_password2.same' => 'Вы не подтвердили новый пароль. Попробуйте заполнить данные более внимательнее',

        ]);

        if ($validator->fails()) {
            return redirect()->route('admin.main')->withInput()->withErrors($validator);
        }
        
        User::ChangePassword(
            $request->input('new_password')
        );
        
        return view('home')->with([
            'users'=> User::getAll(),
            's_message' => 'Пароль изменен',
        ]);
    }

    public function deleteUser($name) {
        $validator = Validator::make([
            'nick' => $name
        ],[
            'nick' => ['required', 'string', 'exists:users,name', new DeleteRule]
        ], [
            'nick.exists' => 'Нет такого пользователя',
        ]);
        if ($validator->fails()) {
            return redirect()->route('admin.main')->withInput()->withErrors($validator);
        }

        User::DelAdmin($name);

        return view('home')->with([
            'users'=> User::getAll(),
            's_message' => 'Пользователь удален',
        ]);
    }

    public function downUser($name) {
        $validator = Validator::make([
            'nick' => $name
        ],[
            'nick' => ['required', 'string', 'exists:users,name', new DownRule]
        ], [
            'nick.exists' => 'Нет такого пользователя',
        ]);
        if ($validator->fails()) {
            return redirect()->route('admin.main')->withInput()->withErrors($validator);
        }

        User::DownAdmin($name);

        return view('home')->with([
            'users'=> User::getAll(),
            's_message' => 'Понижение ранга: Операция успешна',
        ]);
    }

    public function upUser($name) {
        $validator = Validator::make([
            'nick' => $name
        ],[
            'nick' => ['required', 'string', 'exists:users,name', new UpRule]
        ], [
            'nick.exists' => 'Нет такого пользователя',
        ]);
        if ($validator->fails()) {
            return redirect()->route('admin.main')->withInput()->withErrors($validator);
        }

        User::UpAdmin($name);

        return view('home')->with([
            'users'=> User::getAll(),
            's_message' => 'Повышение ранга: Успешная операция',
        ]);
    }
    
    public function authUser(Request $request) {
    	$message = null;

        $user = User::getUser($request->input('name'));  
        if(empty($user)) {
        	$message = 'Данный игрок не админ';
        }
    
        if($user->password == '-') {
            Log::AddLog(14, $request->input('name'), '-', User::GetClientIP());
            $message = 'Вы не зарегестрированы';
        }
    
        if(md5($request->input('password')) != $user->password) {
            Log::AddLog(9, $request->input('name'), '-', User::GetClientIP());
            $message = 'Пароль не верный';
        }

        if(User::GetClientIP() != $user->lastip) {
            Log::AddLog(8, $request->input('name'), '-', User::GetClientIP());
            $message = 'Ваш IP адрес сменился, авторизуйтесь на вашем основном сервере';
        }

        if ($message != null) {
            return view('auth.login', [
                'e_message' => $message
            ]);
        }
    
        $userdata = $user->toArray();

        Session::put('user', $request->input('name'));
        Log::AddLog(4, $request->input('name'), '-', User::GetClientIP());
        
        return view('home')->with([
        	'users'=> User::getAll()
        ]);
    }
}
