<?php
Route::group(['middleware' => ['web']], function () {
    Route::get('/', function () {
        return redirect()->route('admin.main');
    });
    Route::get('/login', function() {
        return view('auth.login');
    })->name('login');
});

Route::group(['middleware' => 'web'], function () {
    Route::post('/admin', 'AdminAuthController@authUser');
    
    Route::post('/validate', 'AdminAuthController@validateuser');
    Route::get('/validate', 'AdminAuthController@validateuser');
});

Route::group(['middleware' => ['web', 'check-admin']], function () {
    Route::get('/admin', 'AdminAuthController@home')->name('admin.main');
    Route::post('/user/change_password', 'AdminAuthController@changePassword')->name('admin.user.change_password');

    Route::get('/admin/logout', 'AdminAuthController@logout')->name('admin.logout');
});

Route::group(['middleware' => ['web', 'check-admin-and-check-permission']], function () {    
    Route::post('/user/add', 'AdminAuthController@addUser')->name('admin.user.add');
    Route::get('/user/delete/{name}', 'AdminAuthController@deleteUser')->name('admin.user.delete');
    Route::get('/user/down/{name}', 'AdminAuthController@downUser')->name('admin.user.down');
    Route::get('/user/up/{name}', 'AdminAuthController@upUser')->name('admin.user.up');
    Route::post('/user/change_password', 'AdminAuthController@changePassword')->name('admin.user.change_password');

    Route::get('/admin/logs', 'LogController@page')->name('admin.logs');
});
