<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \Session;

class ChangePasswordController extends Controller
{
    public function index()
    {
        if (Session::has('user')) {
            $userStatus = User::CheckActiveAdmin();
            if($userStatus == 'success')
            {
                return view("password");
            }
            else {
                return view("auth.login")->with('e_message', $userStatus);
            }
        }
       
        return view("auth.login");
    }
    
    public function changepassword(Request $request) {
    	$s_message = null;
    	$e_message = null;
        if (Session::has('user')) {
            $userStatus = User::CheckActiveAdmin();
            if($userStatus != 'success') {
                return view('auth.login')->with('e_message', $userStatus);
            }
            
            $rqOld = $request->old_password;
            $rqNew = $request->new_password;
            $rqNew2 = $request->new_password2;
            
            $rStatus = User::ChangePassword($rqOld, $rqNew, $rqNew2);
            if($rStatus == 'success') {
                $s_message = 'Вы успешно сменили пароль!';
            }
            else {
                $e_message = $rStatus;
            }

            return view('password')->with([
            	's_message' => $s_message,
            	'e_message' => $e_message
            ]);
        }
        
        return view('auth.login');
    }
}
