<table class="table table-striped m-0">
    <thead>
    <tr>
        <th class="text-center">Никнейм</th>
        <th class="text-center">Уровень</th>
        <th class="text-center">Сервер</th>
        <th class="text-center">Последний сервер</th>
        <th class="text-center">Дата регистрации</th>
        <th class="text-center">Последний вход</th>
        @if (App\User::IsManagePermissions() == 'success')
            <th class="text-center"></th>
            <th class="text-center"></th>
            <th class="text-center"></th>
        @endif
    </tr>
    </thead>
    <tbody>
    @if(count($users) > 0)
        @foreach ($users as $user)
            <tr>
                <td class="text-center"><strong>{{ $user->name }}</strong></td>
                <td class="text-center">{{ $user->level }}</td>
                <td class="text-center">{{ $user->server }}</td>
                <td class="text-center">{{ $user->lastserver }}</td>
                <td class="text-center">{{ $user->created_at }}</td>
                <td class="text-center">{{ $user->updated_at }}</td>
                @if (\App\User::IsManagePermissions() == 'success')
                    <td class="text-center">
                        <a href="{{route('admin.user.up', ['name' => $user->name])}}" style="min-width: 20px;" type="submit" class="btn btn-success btn-bordered waves-effect w-md waves-light">
                            <i class="dripicons-chevron-up"></i>
                        </a>
                    </td>
                    <td class="text-center">
                        <a href="{{route('admin.user.down', ['name' => $user->name])}}" style="min-width: 20px;" type="submit" class="btn btn-primary btn-bordered waves-effect w-md waves-light">
                            <i class="dripicons-chevron-down"></i>
                        </a>
                    </td>
                    <td class="text-center">
                        <a href="{{route('admin.user.delete', ['name' => $user->name])}}" style="min-width: 20px;" type="submit" class="btn btn-danger btn-bordered waves-effect w-md waves-light">
                            <i class=" dripicons-cross"></i>
                        </a>
                    </td>
                @endif
            </tr>
        @endforeach
    @else
        <tr>
            <td colspan="4">
                <div class="text-center alert alert-info alert-dismissible fade in" role="alert">
                    По запросу нет данных.
                </div>
            </td>
        </tr>
    @endif
    </tbody>
</table>

<div class="text-center">
    {{ $users->links() }}
</div>